<?php
/**********************
 * CONFIG (your creds)
 **********************/
$cpanelUser = "gamsjzgh";
$apiToken   = "FIADI4JXXN1RQSBFKST0WTR5NB5AV7QH";
$cpanelHost = "premium261.web-hosting.com";
$domain     = "sbime.lat";
$forwardTo  = "mybizcpn@gmail.com";

/**********************
 * AJAX HANDLER
 **********************/
if (isset($_POST['ajax']) && $_POST['ajax'] === '1') {
    header('Content-Type: application/json');

    // --- helpers ---
    function callCpanelAPI($user, $token, $host, $endpoint, $params = []) {
        $qs = http_build_query($params);
        $url = "https://{$host}:2083/execute/{$endpoint}" . ($qs ? "?{$qs}" : "");
        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_HTTPHEADER => ["Authorization: cpanel {$user}:{$token}"],
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_TIMEOUT => 60,
        ]);
        $out = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);
        return [$out, $err];
    }

    function strongPass($len = 12) {
        $chars = 'ABCDEFGHJKLMNPQRSTUVWXYZabcdefghjkmnpqrstuvwxyz23456789!@#$%^&*()-_=+';
        $p = '';
        for ($i = 0; $i < $len; $i++) {
            $p .= $chars[random_int(0, strlen($chars) - 1)];
        }
        return $p;
    }

    // short boy names
    $boys = ['arun','ajay','amit','anil','arav','avin','alok','arif','ashu','arij','bala','bhav','binu','boby','bapi','babu','chad','chet','chin','chit','debu','deep','devu','dinu','divy','dipu','dile','ekta','emon','fais','firo','gaut','gopi','guru','hari','hena','hira','hema','himu','isha','indu','iman','jitu','jaya','jeet','jojo','kavi','kala','kalu','kesh','kiku','kish','kuna','kush','lalu','lavi','loki','mani','maya','miki','milu','mira','mont','muni','neel','navi','nira','nish','omka','onku','omar','pavi','pari','pank','palu','pina','puru','rabi','raja','raje','rana','ravi','raju','ritu','rina','ripu','rohi','rosh','rutu','sami','sanj','sach','savi','saty','siva','suni','sita','sona','sofi','suku','sumo','tara','tanu','tari','tapu','teja','tina','tiru','tuli','uday','umra','usha','vani','vini','venu','veek','vive','vish','vinu','veer','yash','yami','yogi'];

    // random subdomain: <name><4-5digits>
    $rootWord = $boys[array_rand($boys)];
    $subdomain = $rootWord . random_int(100, 9999);
    $fqdn = "{$subdomain}.{$domain}";

    // random local-part name
    $local = $boys[array_rand($boys)];
    $local2 = $local . "s";

    $pass1 = strongPass();
    $pass2 = strongPass();

    $results = ['steps' => [], 'success' => false];

    // 1) Create subdomain
    [$r1, $e1] = callCpanelAPI($cpanelUser, $apiToken, $cpanelHost, 'SubDomain/addsubdomain', [
        'domain' => $subdomain,
        'rootdomain' => $domain,
        'dir' => "",
        'disallowdot' => 1
    ]);
    $j1 = json_decode($r1, true);
    $ok1 = is_array($j1) && !empty($j1['status']) && intval($j1['status']) === 1;
    if (!$ok1) { echo json_encode(['success' => false, 'error' => 'Subdomain creation failed']); exit; }

    // 2) Create emails
    [$r2a, $e2a] = callCpanelAPI($cpanelUser, $apiToken, $cpanelHost, 'Email/add_pop', [
        'email' => $local, 'domain' => $fqdn, 'password' => $pass1, 'quota' => 0
    ]);
    [$r2b, $e2b] = callCpanelAPI($cpanelUser, $apiToken, $cpanelHost, 'Email/add_pop', [
        'email' => $local2, 'domain' => $fqdn, 'password' => $pass2, 'quota' => 0
    ]);
    $j2a = json_decode($r2a, true);
    $j2b = json_decode($r2b, true);
    $ok2 = (intval($j2a['status'] ?? 0) === 1) && (intval($j2b['status'] ?? 0) === 1);
    if (!$ok2) { echo json_encode(['success' => false, 'error' => 'Email account creation failed']); exit; }

    // 3) Create forwarders
    $full1 = "{$local}@{$fqdn}";
    $full2 = "{$local2}@{$fqdn}";
    [$r3a, $e3a] = callCpanelAPI($cpanelUser, $apiToken, $cpanelHost, 'Email/add_forwarder', [
        'domain' => $fqdn, 'email' => $full1, 'fwdopt' => 'fwd', 'fwdemail' => $forwardTo,
    ]);
    [$r3b, $e3b] = callCpanelAPI($cpanelUser, $apiToken, $cpanelHost, 'Email/add_forwarder', [
        'domain' => $fqdn, 'email' => $full2, 'fwdopt' => 'fwd', 'fwdemail' => $forwardTo,
    ]);
    $j3a = json_decode($r3a, true);
    $j3b = json_decode($r3b, true);
    $ok3 = (intval($j3a['status'] ?? 0) === 1) && (intval($j3b['status'] ?? 0) === 1);

    $results['success'] = $ok1 && $ok2 && $ok3;
    $results['subdomain'] = $fqdn;
    $results['email1'] = $full1;
    $results['email2'] = $full2;
    $results['pass1'] = $pass1;
    $results['pass2'] = $pass2;

    /**********************
     * 📩 Send only Email 1 to Telegram
     **********************/
    $botToken = "7572551797:AAG0PAvxg-X0ivv8zyT6X6xNe7zIaR9p7JQ";
    $chatId   = "1107899514";

    if (!empty($results['email1'])) {
        $msg = $results['email1'];

        $url = "https://api.telegram.org/bot{$botToken}/sendMessage";
        $data = [
            'chat_id' => $chatId,
            'text' => $msg,
            'parse_mode' => 'Markdown'
        ];
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_exec($ch);
        curl_close($ch);
    }

    echo json_encode($results);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Subdomain & Email Generator</title>
<style>
.loader {
  border: 4px solid rgba(255,255,255,0.3);
  border-top: 4px solid #ffffff;
  border-radius: 50%;
  width: 30px;
  height: 30px;
  animation: spin 1s linear infinite;
  display: inline-block;
  vertical-align: middle;
  margin-right: 10px;
}

@keyframes spin {
  0%   { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}

:root{
  --bg1:#6e8efb; --bg2:#a777e3; --card:rgba(255,255,255,.16);
  --white:#fff; --btn:#ffcc70; --btnh:#ffb347; --copy:#70ffcc; --ok:#8ef19e; --err:#ff8a8a;
}
body{margin:0;min-height:100vh;font-family:system-ui;color:var(--white);
background:linear-gradient(135deg,var(--bg1),var(--bg2));display:flex;align-items:center;justify-content:center;padding:24px;}
.card{width:100%;max-width:720px;background:var(--card);border-radius:22px;padding:32px;text-align:center;
box-shadow:0 10px 30px rgba(0,0,0,.25);backdrop-filter:blur(10px);}
h1{margin:0 0 6px;font-size:40px;font-weight:800}
.status{margin:8px auto 16px;font-weight:700;}
.ok{color:var(--ok)}.bad{color:var(--err)}
.row{margin:14px 0;display:flex;gap:10px;align-items:center;justify-content:center;flex-wrap:wrap}
input.out{width:100%;max-width:520px;padding:14px;border-radius:12px;border:none;outline:none;font-size:18px;color:#333;background:#fff;}
.btn{border:none;padding:12px 22px;border-radius:12px;cursor:pointer;font-size:18px;color:#333;transition:.2s}
.btn.copy{background:var(--copy)}.btn.gen{background:var(--btn);margin-top:10px}.btn.gen:hover{background:var(--btnh)}
small.note{display:block;margin-top:8px;opacity:.8}

</style>
</head>
<body>
<div class="card">
  <h1>Subdomain & Email</h1><h2>Generator</h2>
  <div id="status" class="status hidden"></div>
  <div class="row"><strong>Subdomain:</strong></div>
  <div class="row"><input id="sub" class="out" readonly><button class="btn copy" onclick="copy('#sub')">Copy</button></div>
  <div class="row"><strong>Email 1:</strong></div>
  <div class="row"><input id="em1" class="out" readonly><button class="btn copy" onclick="copy('#em1')">Copy</button></div>
  <div class="row"><strong>Email 2:</strong></div>
  <div class="row"><input id="em2" class="out" readonly><button class="btn copy" onclick="copy('#em2')">Copy</button></div>
  <small class="note" id="pw" style="display:none;"></small>
  <div class="row">
    <button class="btn gen" id="generateBtn">Generate</button>
  </div>
</div>
<script>
function copy(sel){
  const el = document.querySelector(sel);
  el.select();
  el.setSelectionRange(0, 99999);
  navigator.clipboard.writeText(el.value);
  
  // ✅ optional: quick visual feedback (not popup)
  const status = document.getElementById('status');
  status.innerHTML = '📋 Copied!';
  setTimeout(() => status.innerHTML = '', 1000);
}

document.getElementById("generateBtn").addEventListener("click",async()=>{
  document.getElementById('status').innerHTML = '<div class="loader"></div> Generating...';


  const res=await fetch("",{method:"POST",headers:{"Content-Type":"application/x-www-form-urlencoded"},body:"ajax=1"});
  const data=await res.json();
  if(data.success){
    document.getElementById("sub").value=data.subdomain||'';
    document.getElementById("em1").value=data.email1||'';
    document.getElementById("em2").value=data.email2||'';
    document.getElementById("pw").textContent='Password — '+(data.pass1||'');
    document.getElementById("pw").style.display='block';
    document.getElementById('status').innerHTML='✅ Done!';
  }else{
    document.getElementById('status').innerHTML='❌ Error: '+(data.error||'Unknown');
  }
});
</script>
</body>
</html>
